package de.davidartmann.rosa.db.async;

import android.content.Context;
import android.os.AsyncTask;

import de.davidartmann.rosa.db.PersonDao;
import de.davidartmann.rosa.model.Person;

/**
 * AsyncTask to soft delete a Person from the DB.
 * This process is the soft deletion of a person (active = 0).
 * Created by david on 04.03.16.
 */
public class SoftDeletePersonInDb extends AsyncTask<Person, Integer, Person> {

    private Context context;
    private PersonDao personDao;
    private ISoftDeletePerson iSoftDeletePerson;

    public SoftDeletePersonInDb(Context context, ISoftDeletePerson iSoftDeletePerson) {
        this.context = context;
        this.iSoftDeletePerson = iSoftDeletePerson;
    }

    @Override
    protected Person doInBackground(Person... persons) {
        personDao = new PersonDao(context);
        personDao.openWritable();
        return personDao.softDelete(persons[0]);
    }

    @Override
    protected void onPostExecute(Person person) {
        super.onPostExecute(person);
        iSoftDeletePerson.onSoftDeleted(person);
        personDao.close();
    }

    public interface ISoftDeletePerson {
        void onSoftDeleted(Person person);
    }
}
